﻿/*****************************************
VERSION: 	1.0


USAGE: 
	#include "functions/rotatePoint.as"
	var global_p = rotatePoint( local_p, global_radian );
	
	
DESCRIPTION: 
	Adds rotation to a Point  (a Point object is technically a vector)
	vector + angle  =  rotated vector  (clockwise)
	
	input:	local_vector, clockwise_radian
	output:	rotated_vector
	
	This enables relative movement like so: 
		Take local velocity
		Apply global rotation to local velocity
		This results in a global velocity
		Add this global velocity to the global position
*****************************************/
function rotatePoint( input_p, apply_clockwise_radian ){
	var Matrix = flash.geom.Matrix;
	var Point = flash.geom.Point;
	
	// Matrix technique
	var work_mat = new Matrix( 1,0,0,1, -input_p.x, -input_p.y );
	work_mat.rotate( apply_clockwise_radian);
	var output = new Point( work_mat.tx, work_mat.ty );
	return output;
}// rotatePoint()